<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;

class SchoolSponsor extends Model
{
    use LogsActivity;

    protected $table = 'schools_sponsors';
    protected $fillable = [
        'school_id',
        'contact_person',
        'phone',
        'email',
        'state',
        'lga',
        'address',
        'is_active',
        'status'
    ];

    protected static $logAttributes = ['*'];

    protected static $logName = 'schools_sponsors';

    public function getDescriptionForEvent(string $eventName): string
    {
        return "schools sponsors has been {$eventName}.";
    }
}
